
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:57:47 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HASH_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_HASH_Acceptance.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"

#include <stdio.h>

#if TST_USE_HASH_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines ***********/
/******** Enums ***********/
/******** Typedefs **********/
/******** Global Data **********/
/***** Private function prototype ******/
CRYSError_t CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS(void);
/******** Public Functions **********/
void CRYS_ATP_TST_HASH_main(void)
{
  DxUint8_t  Var;
  do
   {
     do
     {
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ HASH tests Menu ]-----------------"));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - Acceptance NON integrated           "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - Acceptance Integrated               "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL HASH Acceptance tests          "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu   "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n---------------------------------------\n\n"));
             scanf("\n%c",&Var);
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
             if (Var<='Z')
                      break;
             else
             {
                   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
             }

      }while(1);


      switch(Var)
      {
        case '1':
            CRYS_ATP_TST_HASH_Acceptance_NON_integrated ();
            break;
        case '2':
            CRYS_ATP_TST_HASH_Acceptance_Integrated ();
            break;
        case 'T':
            CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS ();
            break;
           case 'Z':
                  ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of HASH tests \n"));
                  break ;
           default:
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
      }
         if(Var =='Z')
         break;
     }while (1);
}

/***************************
 * Function Name:
 *   CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS
 *
 * Inputs:
 *   none
 *
 * Outputs:
 *   CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the HASH Acceptance tests
 *
 **************************/
CRYSError_t CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS(void)
{
    CRYSError_t        TST_Status = TESTPASS , TST_TestStatus = TESTPASS;
    DxUint8_t          TST_DebugStatus = ATP_EXIT_TEST_AFTER_FAILURE;  

    TST_TestStatus = CRYS_ATP_TST_HASH_Acceptance_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    TST_TestStatus = CRYS_ATP_TST_HASH_Acceptance_Integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE HASH Acceptance TESTS PASS   :-)        ***\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));

return TST_Status;

EXIT_ON_ERROR:

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE HASH TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));

    return TST_Status;

}

#endif

